#include <stdio.h>
#include <stdlib.h>
#include "gd.h"

FILE *logfile;

struct parameter 
  {
  char feature[256];
  char x[256];
  char y[256];
  }

html_error(char *filename)
  {
  printf("Content-type: text/html\n\n");
  printf("File open error: %s",filename);
  exit(1);
  }

void parse_extra(char *extra_path, 
                 struct parameter paramlist[], 
                 char *headimage)
  {
  char *charp,*slash1,*slash2,*slash3;
  int i=0;

  charp = extra_path;
  charp++;

  while(i<256)
    {
    slash1 = strchr(charp,'/');
    if(slash1)
      slash2 = strchr(slash1+1,'/');
    else
      {
/*
      strcpy(paramlist[i].feature,charp);
      strcpy(paramlist[i].x,"ISMAP");
      strcpy(paramlist[i].y,"ISMAP");
      strcpy(paramlist[i+1].feature,"LAST");
*/
      strcpy(paramlist[i].feature,"LAST");
      strcpy(headimage,charp);
      break;
      }
    if(slash2)
      slash3 = strchr(slash2+1,'/');
    else
      {
      html_error("Command line does not parse");
      }

    *slash1=0;
    *slash2=0;

    strcpy(paramlist[i].feature,charp);
    strcpy(paramlist[i].x,slash1+1);

    if(!slash3)
      {
      strcpy(paramlist[i].y,slash2+1);
      strcpy(paramlist[i+1].feature,"LAST");
      break;
      }

    if(strchr(slash3+1,'/'))
      {
      *slash3=0;
      strcpy(paramlist[i].y,slash2+1);
      charp=slash3+1;
      i++;
      }
    else
      {
      *slash3=0;
      strcpy(paramlist[i].y,slash2+1);
/*
      strcpy(paramlist[i+1].feature,slash3+1);
      strcpy(paramlist[i+1].x,"ISMAP");
      strcpy(paramlist[i+1].y,"ISMAP");
      strcpy(paramlist[i+2].feature,"LAST");
*/
      strcpy(paramlist[i+1].feature,"LAST");
      strcpy(headimage,slash3+1);
      break;
      break;
      }
    }
  }

main(int argc, char *argv[])
  {
  char graphic_char, *extra_path, feature_file_name[256], *comma, *docroot;
  char headimage[256], blank_head_filename[276];
  FILE *blank_head_fp, *feature_fp;
  struct parameter paramlist[256];
  gdImagePtr output_image, input_image, feature_image;
  int j,visitor;

  docroot = getenv("DOCUMENT_ROOT");
  if(argc != 2) /* not called as imagemap */
    {
    extra_path = getenv("PATH_INFO");
    if(extra_path)                       /* If called with params, parse them.*/
      {
      parse_extra(extra_path,paramlist,headimage);
      }
    else                                 /* If not, return blank Apple Corps. */
      {
      sprintf(blank_head_filename,"%s/images/ac.apple.gif",docroot);
      if(!(blank_head_fp = fopen(blank_head_filename,"r")))
        html_error(blank_head_filename);
      input_image = gdImageCreateFromGif(blank_head_fp);
      fclose(blank_head_fp);
      output_image = gdImageCreate(input_image->sx,input_image->sy);
      gdImageCopy(output_image,
                  input_image,
                  0,0,
                  0,0,
                  input_image->sx,input_image->sy);
/*
      printf("Content-type: multipart/x-mixed-replace;boundary=ThisRandomString\n");
      printf("\n--ThisRandomString\n");
*/
      printf("Content-type: image/gif\n\n");
      gdImageGif(output_image,stdout);
/*
      printf("\n--ThisRandomString\n");
*/
      gdImageDestroy(output_image);
      gdImageDestroy(input_image);
      exit(1);
      }
    /* use param list to generate Apple Corps and return */
    sprintf(blank_head_filename,"%s/images/ac.%s.gif",
            docroot,
            headimage);
    if(!(blank_head_fp = fopen(blank_head_filename,"r")))
      html_error(blank_head_filename);
    input_image = gdImageCreateFromGif(blank_head_fp);
    fclose(blank_head_fp);
    output_image = gdImageCreate(input_image->sx,input_image->sy);
    gdImageCopy(output_image,
                input_image,
                0,0,
                0,0,
                input_image->sx,input_image->sy);
    j=0;
    while((strcmp(paramlist[j].feature,"LAST"))&&(j<256))
      {
/*
      if(!strcmp(paramlist[j].feature,"PLUCK"))
        {
        while((strcmp(paramlist[k].feature,"LAST"))&&(k<256))
          {
          distance = sqrt((paramlist[k].x-paramlist[j].x)^2 + 
                          (paramlist[k].y-paramlist[j].y)^2);
          }
        }
*/
      sprintf(feature_file_name,"%s/images/ac.%s.gif",
              docroot,
              paramlist[j].feature);
      if(!(feature_fp = fopen(feature_file_name,"r")))
        html_error(feature_file_name);
      feature_image = gdImageCreateFromGif(feature_fp);
      fclose(feature_fp);
      gdImageCopy(output_image,
                  feature_image,
                  atoi(paramlist[j].x)-(feature_image->sx/2),
                  atoi(paramlist[j].y)-(feature_image->sy/2),
                  0,0,
                  feature_image->sx,feature_image->sy);
      gdImageDestroy(feature_image);
      j++;
      }
/*
    printf("Content-type: multipart/x-mixed-replace;boundary=ThisRandomString\n");
    printf("\n--ThisRandomString\n");
*/
    printf("Content-type: image/gif\n\n");
    gdImageGif(output_image,stdout);
/*
    printf("\n--ThisRandomString\n");
*/
    gdImageDestroy(output_image);
    gdImageDestroy(input_image);
    }
  else          /* called as imagemap */
    {
    extra_path = getenv("PATH_INFO");
    comma = strchr(argv[1],',');
    if(!comma)
      html_error("No comma where expected");
    *comma = 0;
    printf("Content-type: text/html\n\n");
    printf("<FORM METHOD=\"POST\" ACTION=\"http://apple-corps.westnet.com/cgi-bin/apple_corps.pl\">\n"); 
    printf("<IMG ALIGN=RIGHT SRC=\"http://apple-corps.westnet.com/cgi-bin/apple_corps.cgi%s/%s/%s\">\n",
           extra_path,
           argv[1],
           comma+1);
    printf("<UL>\n");
    printf("<LI><INPUT TYPE=\"radio\" NAME=\"feature\" VALUE=\"eyes\" CHECKED>\n");
    printf("<IMG SRC=\"http://apple-corps.westnet.com/images/ac.eyes.gif\">\n");
    printf("<LI><INPUT TYPE=\"radio\" NAME=\"feature\" VALUE=\"glasses\">\n");
    printf("<IMG SRC=\"http://apple-corps.westnet.com/images/ac.glasses.gif\">\n");
    printf("<LI><INPUT TYPE=\"radio\" NAME=\"feature\" VALUE=\"nose\">\n");
    printf("<IMG SRC=\"http://apple-corps.westnet.com/images/ac.nose.gif\">\n");
    printf("<LI><INPUT TYPE=\"radio\" NAME=\"feature\" VALUE=\"mouth\">\n");
    printf("<IMG SRC=\"http://apple-corps.westnet.com/images/ac.mouth.gif\">\n");
    printf("</UL>\n");
    printf("<INPUT TYPE=\"hidden\" NAME=\"apple_corps\" VALUE=\"apple_corps.cgi%s/%s/%s\">\n",
           extra_path,
           argv[1],
           comma+1);
    printf("<INPUT TYPE=\"submit\" VALUE=\"Add Feature\">\n");
    printf("</FORM>\n");
    }
  }
